/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.data.mapping;

import dev.quantumfusion.dashloader.DashDataManager;
import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.data.image.shader.DashShader;
import dev.quantumfusion.dashloader.util.MissingDataException;
import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.TaskUtil;
import dev.quantumfusion.taski.builtin.StepTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_5944;

public class DashShaderData {
    public final Map<String, DashShader> shaders;

    public DashShaderData(Map<String, DashShader> shaders) {
        this.shaders = shaders;
    }

    public DashShaderData(DashDataManager data, StepTask parent) {
        this.shaders = new HashMap<String, DashShader>();
        Map<String, class_5944> minecraftData = data.shaders.getMinecraftData();
        parent.run((Task)new StepTask("Shaders"), task -> TaskUtil.forEach((StepTask)task, (Map)minecraftData, (s, shader) -> {
            try {
                this.shaders.put((String)s, new DashShader((class_5944)shader));
            }
            catch (MissingDataException e) {
                DashLoader.LOG.warn("Skipping shader {}", s);
            }
        }));
    }

    public Map<String, class_5944> export() {
        ConcurrentHashMap<String, class_5944> out = new ConcurrentHashMap<String, class_5944>();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.shaders.forEach((key, value) -> runnables.add(() -> out.put((String)key, value.export())));
        DashLoader.DL.thread.parallelRunnable(runnables);
        return out;
    }
}

